package structure
import (
	"database/sql"
	"net/http"
)


type AsyncTagOutput struct {
	
	Html string `json:"html"`
	Width int `json:"width"`
	Height int `json:"height"`
	IframeFriendly bool `json:"iframeFriendly"` 
	
}

type ZoneInfo struct {
	
	Zoneid int 
	Affiliateid int 
	Zonename string 
	Description string 
	Delivery string 
	Zonetype int 
	Category string 
	Width int 
	Height int 
	Ad_selection string 
	Chain string 
	Prepend string 
	Append string 
	Appendtype int 
	Forceappend string 
	Inventory_forecast_type int 
	Comments string 
	Cost float64 
	Cost_type int 
	Cost_iable_id string 
	Technology_cost float64 
	Technology_cost_type int 
	Updated string 
	Block int 
	Capping int 
	Session_capping int 
	What string 
	Rate float64 
	Pricing string 
	Oac_category_id int 
	Ext_adselection string 
	Show_capped_no_cookie int 
	Inventory_type int 
	Inv_type int 
	Ssp_buyer string 
	Passbacktag string 
	Vidtype int 
	Reward string 
	Amount string 
	Position string 
	Layout string 
	Infeedads string 
	Infeedpos string 
	Adposition string 
	Adinterval string 

}

type AdLinkedZone struct {
	
	 Ad_id int
	 Placement_id int
	 Status int
	 Width int
	 Ext_bannertype string
	 Height int
	 Type string
	 Weight int
	 Adserver string
	 Block_ad int
	 Cap_ad int
	 Session_cap_ad int
	 Compiledlimitation string
	 Acl_plugins sql.NullString
	 Alt_filename string
	 Priority float64
	 Priority_factor int
	 To_be_delivered int
	 Campaign_id int
	 Campaign_priority int
	 Campaign_weight int
	 Campaign_companion int
	 Block_campaign int
	 Cap_campaign int
	 Session_cap_campaign int
	 Show_capped_no_cookie int
	 Client_id int
	 Expire_time string
	 Revenue_type int
	 Ecpm_enabled int
	 Ecpm float64
	 Tracker_status string
	 PriorityFinal float64
}


type GlobalVariables struct {
	
	R *http.Request
	Ip_address string
	Latitude string
	Longitude string
	Country_code string
	Country_name string
	Subdivision_one string
	Subdivision_two string
	Continent string
	City string
	Postal_code string
	UsMetro string
	Organisation string
	ConnectionType string
	Useragent string
	DeviceName string
	DeviceModel string
	DeviceType string
	Os string
	Osv string
	OsShort string
	Language string
	Domain string
	Browser string
	BrowserVersion string
	BrowserShort string
	Hostname string
	PageURL string
	RefURL string
	DomainName string
	Source string
	
	
	}
	


type AdDetails struct {
	
 	Ad_id int
	Placement_id int
	Status int
	Name string
	Type string
	Contenttype string
	Pluginversion int
	Filename string
	Imageurl string
	Htmltemplate string
	Htmlcache string
	Width int
	Height int
	Weight int
	Seq int
	Target string
	Url string
	Alt string
	Statustext string
	Bannertext string
	Adserver string
	Block_ad int
	Cap_ad int
	Session_cap_ad int
	Compiledlimitation string
	Acl_plugins sql.NullString
	Prepend string
	Append string
	Bannertype int
	Alt_filename string
	Alt_imageurl string
	Alt_contenttype string
	Parameters string
	Transparent int
	Ext_bannertype string
	Iframe_friendly int
	Campaign_id int
	Block_campaign int
	Cap_campaign int
	Session_cap_campaign int
	Show_capped_no_cookie int
	Client_id int
	Clickwindow int
	Viewwindow int
	Advertiser_limitation int
	Agency_id int
	Campaign_status int
	Html string
	Imp_url string
	Click_url string
	
	
}








type SspRequestImg struct {
	
	Id string `json:"id"`
	Tmax int `json:"tmax"`
	Gzip int `json:"gzip"` 
	Dsp []DspObjects `json:"dsp,omitempty"`
	Imp []ImpImgObjects `json:"imp,omitempty"`
	Site SiteObjects `json:"site,omitempty"`
	Device DeviceObjects `json:"device,omitempty"`
	User UserObjects `json:"user,omitempty"`
	Regs RegsObjects `json:"regs,omitempty"`
	
}

type SspRequestVideo struct {
	
	Id string `json:"id"`
	Tmax int `json:"tmax"`
	Gzip int `json:"gzip"` 
	Dsp []DspObjects `json:"dsp,omitempty"`
	Imp []ImpVideoObjects `json:"imp,omitempty"`
	Site SiteObjects `json:"site,omitempty"`
	Device DeviceObjects `json:"device,omitempty"`
	User UserObjects `json:"user,omitempty"`
	Regs RegsObjects `json:"regs,omitempty"`
	
}
 

type DspObjects struct {
	
	Id int `json:"id"`
	Ver string `json:"ver"`
	Ping_url string `json:"ping_url"`
	At int `json:"at"`
	Cur []string `json:"cur"`
	Ext DspObjects__ext  `json:"ext,omitempty"`
	Source DspObjects__source `json:"source"`
	Gzip int `json:"gzip"`

}


type DspObjects__ext struct{
	
	Ads_txt DspObjects__ext__ads_txt `json:"ads_txt,omitempty"`
}

type DspObjects__ext__ads_txt struct {
	
	Status int `json:"status,omitempty"`
	Auth_id string `json:"auth_id,omitempty"`
	Pub_id string `json:"pub_id,omitempty"`
}


type DspObjects__source struct {
	
	Tid string `json:"tid"`
	Ts int `json:"ts"`
	Ds string `json:"ds"`
}



type ImpImgObjects struct { 
	Id string `json:"id"`
	Bidfloor float64 `json:"bidfloor"`
	Pmp ImpObjects__pmp `json:"pmp"`
	Banner ImpObjects__banner `json:"banner,omitempty"`
	
} 

type ImpVideoObjects struct { 
	Id string `json:"id"`
	Bidfloor float64 `json:"bidfloor"`
	Pmp ImpObjects__pmp `json:"pmp"`
	Video ImpObjects__video`json:"video,omitempty"`
	
} 

type ImpObjects__pmp struct {
	Private_auction int `json:"private_auction"`
	Deals []ImpObjects__pmp__deals `json:"deals"`
	
}

type ImpObjects__pmp__deals struct {
	
	Id string `json:"id"`
	At int `json:"at"`
	Bidfloor float64 `json:"bidfloor"`
	Wseat []string `json:"wseat"`
	
} 

type ImpObjects__banner struct {

H int `json:"h"`
W int `json:"w"`
Pos int `json:"pos"`
Mimes []string `json:"mimes"`

}


type ImpObjects__video struct {
	 
	W int `json:"w,omitempty"`
	H int `json:"h,omitempty"`
	Pos int `json:"pos,omitempty"`
	Startdelay int `json:"startdelay,omitempty"`
	Minduration int `json:"minduration,omitempty"`
	Maxduration int `json:"maxduration,omitempty"`
	Maxextended int `json:"maxextended,omitempty"`
	Minbitrate int `json:"minbitrate,omitempty"`
	Maxbitrate int `json:"maxbitrate"`
	Api []int `json:"api,omitempty,omitempty"`
	Protocols []int  `json:"protocols,omitempty"`
	Mimes []string `json:"mimes,omitempty"`
	Linearity int `json:"linearity"`
	Boxingallowed int `json:"boxingallowed"`
	Playbackmethod []int `json:"playbackmethod,omitempty"`
	Delivery []int `json:"delivery,omitempty,omitempty"`
	Battr []int `json:"battr,omitempty,omitempty"`
	Companionad []ImpObjects__video__companionad `json:"companionad,omitempty"`
	Companiontype []int `json:"companiontype,omitempty"`
	
}

type ImpObjects__video__companionad struct {
	
	Id string `json:"id,omitempty"`
	W int `json:"w,omitempty"`
	H int `json:"h,omitempty"`
	Pos int `json:"pos,omitempty"`
	Battr []int `json:"battr,omitempty"`
	Expdir []int `json:"expdir,omitempty"`
	
}



type SiteObjects struct {
	Id string `json:"id"`
	Name string `json:"name"`
	Domain string `json:"domain"`
	Page string `json:"page"`
	Pagecat []string `json:"pagecat"`
	Mobile int `json:"mobile"`
	Amp int `json:"mobile"`
	Pub SiteObjects__pub `json:"pub"`
		
	}
	
type SiteObjects__pub struct {
	Id string `json:"id"`
	Name string `json:"name"`
	Domain string `json:"domain"`	
	}
	
	
	
	
	
	
type DeviceObjects struct {
	Type int `json:"type"`
	Ifa string `json:"ifa"`
	Ip string `json:"ip"`
	Ua string `json:"ua"`
	Make string `json:"make"`
	Model string `json:"model"`
	Devicetype	int `json:"devicetype"`
	Hwv string `json:"hwv"`
	Os string `json:"os"`
	Osv string `json:"osv"`
	Mccmnc string `json:"mccmnc"`
	Geo DeviceObjects__geo `json:"geo"`
		
	}
	
	
type DeviceObjects__geo struct {
	Type int `json:"type"`
	Lat float64 `json:"lat"`
	Lon float64 `json:"lon"`
	Country string `json:"country"`
	Utcoffset int `json:"utcoffset"`
		
	}  
	
	
	
	

type UserObjects struct {
	Id string `json:"id"`
	Consent string `json:"consent"`
	Buyeruid string `json:"buyeruid"`
	Yob int `json:"yob"`
	Gender string `json:"gender"`
	Data []UserObjects__data `json:"data"`
	Ext UserObjects__ext  `json:"ext"`
		
	}
	
type UserObjects__data struct {
	Id string `json:"id"`
	Name string `json:"name"`
	Segment []UserObjects__data__segment  `json:"segment"`
		
	}	
	
type UserObjects__data__segment struct {
	Id string `json:"id"`
	Name string `json:"name"`
	Value string `json:"value"`
	
		
	}
	
type UserObjects__ext struct {
	Consented_providers_settings []UserObjects__ext_cps  `json:"consented_providers_settings"`
	
}
type UserObjects__ext_cps struct {
	Consented_providers []int `json:"consented_providers"`
} 


type RegsObjects struct {
	Coppa int `json:"coppa"`
	}	
		
	
	
type AdExchangeZone struct {
	 
	
Zoneid int
Req_test int
Req_tmax int
Req_wseat string
Req_allimps int
Req_bcat string
Req_badv string
Req_bapp string
Req_regs string
Imp_dm string
Imp_dms string
Imp_tagid string
Imp_bidfloor float64
Imp_bidfloorcur string
Imp_cb int
Imp_secure int
Imp_iframe string
Imp_exp int
Imp_pmp string
Ban_btype string
Ban_battr string
Ban_mimes string
Vid_width int
Vid_height int
Vid_playervideo string
Vid_mimes string
Vid_min int
Vid_max int
Vid_protocol string
Vid_sd int
Vid_roll_sec int
Vid_lin int
Vid_skip int
Vid_skipmin int
Vid_skipafter int
Vid_seq int
Vid_battr string
Vid_maxext int
Vid_minbit int
Vid_maxbit int
Vid_box int
Vid_play string
Vid_del int
Vid_pos int
Vid_compad string
Vid_api string
Vid_comptype string
Vid_comp_width int
Vid_comp_height int
Deal_bidfloor float64
Deal_bidfloorcur string
Deal_wseat string
Deal_wadomain string
Site_cat string
Site_section string
Site_page string
Site_key string
Site_content string
Site_privacy int
App_id string
App_name string
App_bundle string
App_url string
App_cat string
App_section string
App_page string
App_privacy string
App_ver string
App_paid int
App_key string
Pub_cat string
Pub_domain string
Cont_epi int
Cont_title string
Cont_series string
Cont_season string
Cont_prod string
Cont_cat string
Cont_prodq int
Cont_vq int
Cont_context int
Cont_cr string
Cont_ur string
Cont_mr int
Cont_key string
Cont_len int
Cont_lang string
Cont_embed int
Cont_data string
Prod_name string
Prod_cat string
Prod_domain string
Dev_dnt int
Dev_lmt int
Geo_accuracy int
Geo_lf int
User_bid string
User_yob int
User_gender string
User_key string
User_cd string
User_data string
Data_name string
Data_seg string
Seg_name string
Seg_value string
Format_w int
Format_h int
Nat_lay int
Nat_adunit int
Nat_len int
Nat_type int
Nat_width int
Nat_height int
Nat_img_mimes string
Nat_vid_width int
Nat_vid_height int
Nat_vid_playervideo string
Nat_vid_mimes string
Nat_min int
Nat_max int
Nat_vid_protocol string
Nat_datatype int
Nat_datalength int
Nat_lin int
Rtb_id string
Nat_id string
Nat_widheight string
Aud_mimes string
Aud_min int
Aud_max int
Aud_protocol string
Aud_battr string
Aud_maxext int
Aud_minbit int
Aud_maxbit int
Aud_del string
Aud_comptype string
Aud_maxseq int
Aud_feed int
Aud_nvol int
Aud_dl int
Pmp int
Deal_id string
Below_img string
Desk_height string
Desk_width string
Img_height string
Img_width string
Native_objects string
 

	}
	
	
type ExchangeDetails struct {
	
Exchange_id int
Exchange_name string
Open_rtb_version string
Status int
Ping_url string
Auction_currency int
Auction_type int
Digital_signature string
Gzip int 

}

type DealsDetails struct {
	
	Dealid int
	Dealid_token string
	Auction_type int
	Floor_price float64
	Zones string
	Adsize string
	Whitelist string
	
} 
	
	
	
 type ExternalResponse struct {
	Ads struct {
		Num1 struct {
			ID    string `json:"id"`
			Bidid string `json:"bidid"`
			Cur   string `json:"cur"`
			Seat  string `json:"seat"`
			Imp   string `json:"imp"`
			Adid  string `json:"adid"`
			Cid   string `json:"cid"`
			Adm   string `json:"adm"`
			Price int    `json:"price"`
			Burl  string `json:"burl"`
		} `json:"1"`
	} `json:"ads"`
}





type VideoAd struct {
	Banner_vast_element_id                   int
	Banner_id                                int
	Vast_element_type                        string
	Vast_video_id                            sql.NullString
	Vast_type                                int
	Vast_video_duration                      sql.NullInt64
	Vast_video_delivery                      sql.NullString
	Get_third_internal_type                  int
	Vast_video_type                          sql.NullString
	Vast_video_bitrate                       sql.NullString
	Vast_net_connection_url                  string
	Vast_video_filename                      sql.NullString
	Vast_video_height                        sql.NullInt64
	Vast_video_width                         sql.NullInt64
	Vast_video_outgoing_filename             sql.NullString
	Vast_companion_banner_id                 int
	Vast_overlay_height                      sql.NullInt64
	Vast_overlay_width                       sql.NullInt64
	Vast_video_clickthrough_url              sql.NullString
	Vast_overlay_action                      sql.NullString
	Vast_overlay_format                      sql.NullString
	Vast_overlay_text_title                  sql.NullString
	Vast_overlay_text_description            sql.NullString
	Vast_overlay_text_call                   sql.NullString
	Vast_creative_type                       sql.NullString
	Vast_thirdparty_impression               string
	Vast_wrapper_url                         string
	Vast_version                             string
	Vast_overlay_wrapper                     sql.NullString
	Vast_overlay_version                     sql.NullString
	Vast_video_skip_duration                 sql.NullString
	Vast_video_skip_progress_duration        sql.NullString
	Vast_thirdparty_clicktracking            sql.NullString
	Vast_thirdparty_clickcustom              sql.NullString
	Vast_overlay_expanded_width              sql.NullInt64
	Vast_overlay_expanded_height             sql.NullInt64
	Vast_thirdparty_companion_expandedwidth  int
	Vast_thirdparty_companion_expandedheight int
	Vast_thirdparty_companion_clicktracking  string
	Vast_overlay_expandedminduration         sql.NullString
	Vast_wrapper_followadditional            int
	Vast_wrapper_allowmultipleads            int
	Vast_wrapper_fallbacknoads               int
	Vast_thirdparty_companion_assetwidth     sql.NullInt64
	Vast_thirdparty_companion_assetheight    sql.NullInt64
	Vast_thirdparty_companion_pxratio        sql.NullString
	Vast_thirdparty_companion_alttext        sql.NullString
	Vast4_min_bitrate                        sql.NullInt64
	Vast4_max_bitrate                        sql.NullInt64
	Vast4_verificationurl2                   sql.NullString
	Vast4_verificationurl1                   sql.NullString
	Vast4_adverificationtype2                string
	Vast4_adverificationtype1                string
	Is_conditionalad                         int
	Vast_icon_filename                       sql.NullString
	Vast_icon_xposition                      sql.NullInt64
	Vast_icon_yposition                      sql.NullInt64
	Vast_icon_duration                       sql.NullString
	Vast_icon_offset                         sql.NullString
	Vast_icon_height                         int
	Vast_icon_width                          int
	Icon_click_url                           sql.NullString
	Icon_track_url                           sql.NullString
	Iabcategory                              sql.NullString
	Vast_video_outgoing_filename1            sql.NullString
	Vast_video_type_1                        sql.NullString
	Vast_video_bitrate_1                     sql.NullString
	Vast_video_outgoing_filename2            sql.NullString
	Vast_video_type_2                        sql.NullString
	Vast_video_bitrate_2                     sql.NullString
	Ad_type                                  int
	Audio_type                               int
	Interactive_mediafile                    string
	Is_mezzininefile                         int
	Mezzanine_en                             int
	Internal_file                            string
	Url_file                                 string
	Vast_4_1_url                             string
	Vast_4_1_type_file                       string
	Vast_4_1_language                        string
	Vast_4_1_url_1                           string
	Vast_4_1_type_file_1                     string
	Vast_4_1_language_1                      string
	Vast_4_1_url_2                           string
	Vast_4_1_type_file_2                     string
	Vast_4_1_language_2                      string
	Blocked_category                         string
}



type Cache_DealsDetails struct {
	
	In                      int
	MatchedDeals            []DealsDetails
}








type SspRequestNative struct {
	
	Id string `json:"id"`
	Tmax int `json:"tmax"`
	Gzip int `json:"gzip"` 
	Dsp []DspObjects `json:"dsp,omitempty"`
	Imp []ImpNativeObjects `json:"imp,omitempty"`
	Site SiteObjects `json:"site,omitempty"`
	Device DeviceObjects `json:"device,omitempty"`
	User UserObjects `json:"user,omitempty"`
	Regs RegsObjects `json:"regs,omitempty"`
	
}


type ImpNativeObjects struct{
	Id string `json:"id,omitempty"`
	Bidfloor float64 `json:"bidfloor"`
	Natives Nativeobj_details `json:"native,omitempty"`

}

type Nativeobj_details struct {
	NativeReq NativeRequests `json:"request"`
}
type NativeRequests struct{
	Assets         []interface{} `json:"assets"`


}


//Nativeassets for native
type Nativeobj_assetsTitle struct {
	Id       int      `json:"id"`
	Required int      `json:"req"`
	Title    Nativeobj_assetsTitle_details `json:"title"`
}


//Nativeassets for native
type Nativeobj_assetsVideo struct {
	Id       int      `json:"id"`
	Video    ImpObjects__video `json:"video"`
}





//Nativetitle for native
type Nativeobj_assetsTitle_details struct {
	Lens int `json:"len"`
}


type Nativeobj_assetsImg struct {
	Id       int      `json:"id"`
	Required int      `json:"req,omitempty"`
	Img      Nativeobj_assetsImg_Details   `json:"img"`
}
//Nativeimg for native
type Nativeobj_assetsImg_Details struct {
	W  int `json:"w,omitempty"`
	H  int `json:"h,omitempty"`
	Type  int `json:"type"`
	
}

type Nativeobj_assetsData struct {
	Id       int      `json:"id"`
	Required int      `json:"req"`
	Data      Nativeobj_assetsData_details   `json:"data"`
}

//Nativedata for native
type Nativeobj_assetsData_details struct {
	Type int `json:"type"`
	Len   int `json:"len,omitempty"`
}









type NativeInternal struct{
	
	Title string
	Logo_image string
	Main_image string
	Main_image_width int
	Main_image_height int
	
	Dj_data_sponsored string
	Dj_data_desc string
	Dj_data_rating string
	Dj_data_likes string
	Dj_data_downloads string
	Dj_data_price string
	Dj_data_salesprice string
	Dj_data_phoneno string
	Dj_data_address string
	Dj_data_desc2 string
	Dj_data_displayurl string
	Dj_data_ctatext string
	
	Html string
	
}




type Sdk_AdDelivery struct {
	
	Imp_url    string      `json:"imp_url,omitempty"`
	Ad_type    string      `json:"ad_type,omitempty"`
	Ad_tag     string      `json:"ad_tag,omitempty"`
	Click_url  string      `json:"click_url,omitempty"`

}

type Sdk_Error struct {
	Code    int      `json:"code,omitempty"`
	Description    string      `json:"description,omitempty"`
	
}
	
	
